<?php
/* --------------------------------------------------------------
 SessionDataLoader.php 2020-02-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\Customer\SimpleCustomerService;
use Smarty;

/**
 * Class SessionDataLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class SessionDataLoader implements LoaderInterface
{
    /**
     * @var SimpleCustomerService
     */
    private $customerService;
    
    /**
     * @var int
     */
    private $customerId;
    
    /**
     * @var int
     */
    private $languageId;
    
    
    /**
     * SessionDataLoader constructor.
     *
     * @param SimpleCustomerService $customerService
     * @param UserPreferences       $userPreferences
     */
    public function __construct(SimpleCustomerService $customerService, UserPreferences $userPreferences)
    {
        $this->customerService = $customerService;
        $this->customerId      = $userPreferences->customerId();
        $this->languageId      = $userPreferences->languageId();
    }
    
    
    /**
     * Loads session data and assign it to smarty.
     *
     * @param Smarty $smarty
     */
    public function load(Smarty $smarty): void
    {
        $customerName = $this->customerService->getName($this->customerId);
        
        $smartySessionData = [
            'customer_id'         => $this->customerId,
            'languages_id'        => $this->languageId,
            'customer_first_name' => $customerName->firstName(),
            'customer_last_name'  => $customerName->lastName(),
        ];
        $smarty->assign('_SESSION', $smartySessionData);
    }
}